﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodSchoolsIndex : BaseAPIMethod
        {

            public MethodSchoolsIndex(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "schoolsindex"; }
            }

            protected override void DoReadRequestParams()
            {
                // nic, bo czytamy wszystkie szkoły
            }

            /// <summary>
            /// Tutaj musimy nadpisac walidacje bazowa, bo nie ma sesji
            /// wiec sprawdzamy tylko czy sa parametry w URLu wlasciwe
            /// </summary>
            /// <returns></returns>
            protected override bool IsValid()
            {
                return DoValidate();
            }

            protected override bool DoValidate()
            {
                return true;
            }

            protected override GResponseData DoGetGResponseData()
            {
                List<GSchoolIndex> _listGSchoolIndex = Component.BLELearning.APIMobile.GetGSchoolsIndexList();
                StatusCode = StatusCodeType.OK;
                return new GResponseData_SchoolsIndex() { Schools = _listGSchoolIndex, count = _listGSchoolIndex.Count };
            }
        }
    }
}